@php
    use DefStudio\GameEngine\Models\Task;

    /** @var Task $task */
@endphp

<x-card>
    @if($isModal)
        <x-slot name="header" class="!bg-gray-200 font-bold uppercase">
            @if($task->exists)
                {{__('Edit Task')}}
            @else
                {{__('Create Task')}}
            @endif
        </x-slot>
    @endif

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">

        <x-text model="task.title" :label="__('Title')"/>
        <x-select model="task.type" :label="__('Type')"
                  :options="game_engine()->available_task_types()->mapWithKeys(fn(string $task_class) => [$task_class => $task_class::type_label()])"
                  unselected="-- {{__('Choose a task type')}} --"
        />
    </div>

    @if($task instanceof \DefStudio\GameEngine\Decorators\Tasks\TaskDecorator)
        <div class="mt-6">
            <x-dynamic-component :component="$task::configuration_component()"/>
        </div>

        <x-game-engine::storytellings.manager class="mt-6" :target="$task->model"/>

        <x-game-engine::tags.manager class="mt-6" :available_tags="game_engine()->task_extractor()->task_tags()"/>
    @endif

    <x-slot name="actions">
        @if($this->isModal)
            <x-button class="mr-auto" wire:loading.disable color="secondary" wire:click="$emit('closeModal')">
                @if(is_object($task) && $task->isDirty())
                    {{__('Abort')}}
                @else
                    {{__('Close')}}
                @endif
            </x-button>
        @endif

        <x-button wire:loading.disable wire:click="save">{{__('Save')}}</x-button>
    </x-slot>
</x-card>

