<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Http\Controllers;

use DefStudio\GameEngine\Models\User;
use Illuminate\Contracts\View\View;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class UsersController
{
    use AuthorizesRequests;

    public function index()
    {
        $this->authorize('viewAny', game_engine()->userClass());

        return view('game-engine::admin.users.index');
    }

    public function create()
    {
        $this->authorize('create', app(User::class));

        return view('game-engine::admin.users.edit');
    }

    public function edit(int $user)
    {
        $user = \game_engine()->userQuery()->findOrFail($user);
        $this->authorize('update', $user);

        return view('game-engine::admin.users.edit', ['user' => $user]);
    }

    public function reset_password(int $user): View
    {
        abort_if(request()->hasValidSignature(), 401);

        $user = game_engine()->userQuery()->findOrFail($user);

        return view('game-engine::users.reset_password', ['user' => $user]);
    }
}
