@php
    /** @var \DefStudio\GameEngine\Http\Livewire\Tasks\Edit $this */

    /** @var \DefStudio\GameEngine\Decorators\Tasks\MultipleChoiceQuestion $task */
    $task = $this->task;

    $available_locales = \DefStudio\GameEngine\Actions\Users\FindAvailableLocales::run();
@endphp

<div class="flex flex-col gap-6">

    <x-game-engine::elements.localized-editor
        id="question_editor"
        model="task.configuration.question"
        :label="trans_choice('Question|Questions', 1)"
        :setup_data="$this->task->configuration['question'] ?? []"
        :locales="$available_locales"
    />

    <div class="flex flex-col gap-6">
        @php
            $available_awards = \DefStudio\GameEngine\Actions\Awards\GetAwardsForScope::run($this->task->model);
        @endphp
        @foreach($task->answers() ?? [] as $answer_index => $answer_data)
            <x-game-engine::elements.labeled-divider x-data="{show_awards: false}" class="flex flex-col gap-4" :label="__('Answer :index', ['index' => $answer_index+1])">

                <div class="flex">
                    <x-game-engine::elements.localized-editor
                        id="answer_editor_{{$answer_index}}"
                        class="grow"
                        model="task.configuration.answers.{{$answer_index}}.answer"
                        :setup_data="$answer_data['answer']"
                        :locales="$available_locales"
                    />

                    <div class="mt-4 ml-4 flex flex-col">
                        <x-checkbox model="task.configuration.answers.{{$answer_index}}.correct" :label="__('Correct')" defer/>
                        <div>
                            @if($available_awards->isNotEmpty())
                                <x-button icon="star"
                                          color="secondary"
                                          size="sm"
                                          wire:loading.disable
                                          title="{{trans_choice('Award|Awards', 2)}}"
                                          @click="show_awards = !show_awards"
                                />
                            @endif
                            <x-button class="ml-auto"
                                      icon="trash"
                                      color="secondary"
                                      size="sm"
                                      wire:click="delete_answer({{$answer_index}})"
                                      wire:loading.disable
                            />
                        </div>
                    </div>
                </div>

                <x-game-engine::awards.assign x-show="show_awards" :awards="$available_awards" model="task.configuration.answers.{{$answer_index}}.awards"/>

            </x-game-engine::elements.labeled-divider>
        @endforeach

        <x-button color="secondary"
                  size="sm"
                  icon="plus"
                  class="mr-auto"
                  wire:click="add_answer"
                  wire:loading.disable
        >{{__('Add Answer')}}</x-button>

        <div>
            <x-checkbox model="task.configuration.randomize_answers_order" :label="__('Randomize answer order')"/>
        </div>
    </div>
</div>
