@php
    use DefStudio\GameEngine\Models\Storytelling;
    use DefStudio\GameEngine\Enums\StorytellingType;
    use DefStudio\GameEngine\Enums\MediaCollection;

    /** @var Storytelling $storytelling */
@endphp

<x-card>
    @if($isModal)
        <x-slot name="header" class="!bg-gray-200 font-bold uppercase">
            @if($storytelling->exists)
                {{__('Edit Storytelling')}}
            @else
                {{__('Create Storytelling')}}
            @endif
        </x-slot>
    @endif

    <div class="flex flex-col gap-6">
        <x-select :options="game_engine()->available_storytelling_types()->mapWithKeys(fn(StorytellingType $storytelling_type) => [$storytelling_type->value => $storytelling_type->label()])"
                  model="storytelling.type" defer
        ></x-select>


        <x-game-engine::livewire.storytelling.edit.assets/>

        <x-select :w-full="false" :options="['right' => __('Right'), 'left' => __('Left')]" model="storytelling.avatar_position" :label="__('Avatar Position')"/>

        <x-game-engine::elements.localized-editor
            id="storytelling_text"
            model="storytelling.text"
            :label="__('Text')"
            :setup_data="$storytelling->text"
            :locales="$available_locales"
        />
    </div>

    <x-slot name="actions">
        @if($this->isModal)
            <x-button class="mr-auto" wire:loading.disable color="secondary" wire:click="$emit('closeModal')">
                @if(is_object($storytelling) && $storytelling->isDirty())
                    {{__('Abort')}}
                @else
                    {{__('Close')}}
                @endif
            </x-button>
        @endif

        <x-button wire:loading.disable wire:click="save">{{__('Save')}}</x-button>
    </x-slot>
</x-card>

