<?php

namespace DefStudio\GameEngine\Actions\Users;

use Locale;
use DefStudio\Actions\Action;
use DefStudio\GameEngine\Enums\Feature;
use Barryvdh\TranslationManager\Manager;

/**
 * @method static array<string, string> run()
 */
class FindAvailableLocales extends Action
{
    /**
     * @return array<string, string>
     */
    public function handle(): array
    {
        $locales = Feature::multi_language->enabled()
            ? app(Manager::class)->getLocales()
            : [config('app.locale')];

        return collect($locales)
            ->sortBy(fn(string $locale) => $locale === config('app.locale') ? 0 : 1)
            ->keyBy(fn(string $locale) => $locale)
            ->map(fn(string $locale): string => Locale::getDisplayLanguage($locale))
            ->toArray();
    }
}
