<?php

namespace DefStudio\GameEngine\Http\Livewire\Runs\Concerns;

use Livewire\Event;

trait OpensModals
{
    protected function open_modal(string $modal, array $params): void
    {
        $this->eventQueue = array_filter($this->eventQueue, function(Event $event) {
            if ($event->serialize()['event'] === 'closeModal') {
                return false;
            }

            return true;
        });
        $this->emit('openModal', $modal, $params);
    }

    public function close_modal(): void
    {
        if (collect($this->getEventQueue())->filter(fn(array $event_data) => $event_data['event'] === 'openModal')->isNotEmpty()) {
            return;
        }

        $this->emit('closeModal', true);
    }
}
