<?php

namespace DefStudio\GameEngine\Http\Livewire\Stories;

use Livewire\Component;
use Illuminate\Contracts\View\View;
use DefStudio\GameEngine\Models\Story;
use DefStudio\GameEngine\Actions\Maps\DeleteMap;
use DefStudio\GameEngine\Actions\Livewire\Sortable\UpdateOrder;

class Maps extends Component
{
    /** @var Story */
    public $story;

    protected $listeners = [
        'map.created' => '$refresh',
        'map.updated' => '$refresh',
    ];

    public function render(): View
    {
        return view('game-engine::livewire.admin.stories.maps');
    }

    public function delete_map(int $map_id): void
    {
        $map = $this->story->maps()->findOrFail($map_id);

        DeleteMap::run($map);

        $this->story->unsetRelation('maps');
    }

    public function update_maps_order(array $new_order): void
    {
        UpdateOrder::run($this->story->maps, $new_order);
    }
}
