<?php

namespace DefStudio\GameEngine\Database\Factories;

use DefStudio\GameEngine\Enums\MediaCollection;
use DefStudio\GameEngine\Enums\StorytellingType;
use Illuminate\Database\Eloquent\Factories\Factory;
use DefStudio\GameEngine\Database\Factories\Concerns\HasMedia;
use function game_engine;

class StorytellingFactory extends Factory
{
    use HasMedia;

    public function modelName(): string
    {
        return game_engine()->storytellingClass();
    }

    public function definition(): array
    {
        return [
            'type' => fake()->randomElement(StorytellingType::cases()),
            'text' => ['en' => fake()->realTextBetween()],
            'target_id' => 0,
            'target_type' => 'foo',
            'avatar_position' => fake()->randomElement(['left', 'right']),
        ];
    }

    public function with_background_image(string $path = null): StorytellingFactory
    {
        return $this->with_media(MediaCollection::background, $path);
    }

    public function with_avatar_image(string $path = null): StorytellingFactory
    {
        return $this->with_media(MediaCollection::avatar, $path);
    }
}
