<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Actions\Runs;

use DefStudio\Actions\Action;
use DefStudio\GameEngine\Enums\Role;
use DefStudio\GameEngine\Models\Run;
use DefStudio\GameEngine\Models\User;
use DefStudio\GameEngine\Models\Story;
use DefStudio\GameEngine\Enums\Feature;
use DefStudio\GameEngine\Exceptions\StoryException;

/**
 * @method static Run run(User $user, Story $story)
 */
class CreateRun extends Action
{
    public function handle(User $user, Story $story): Run
    {
        if ($user->completed_story($story) && Feature::allow_replay->disabled()) {
            throw_unless($user->hasRole(Role::super_admin), StoryException::already_played($user));
        }

        /** @var Run $run */
        $run = game_engine()->runQuery()->create([
            'user_id' => $user->id,
            'story_id' => $story->id,
        ]);

        $run->setRelation('user', $user);
        $run->setRelation('story', $story);

        return $run;
    }
}
