<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Http\Controllers;

use Illuminate\Contracts\View\View;
use DefStudio\GameEngine\Models\Organization;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use function game_engine;

class StoriesController
{
    use AuthorizesRequests;

    public function index(): View
    {
        $organization = game_engine()->organizationQuery()->findOrFail(game_engine()->user()->current_organization_id);

        $this->authorize('viewAny', game_engine()->storyClass());

        return view('game-engine::admin.stories.index', ['organization' => $organization]);
    }

    public function create(): View
    {
        $organization = game_engine()->organizationQuery()->findOrFail(game_engine()->user()->current_organization_id);

        $this->authorize('create', game_engine()->storyClass());

        return view('game-engine::admin.stories.edit', ['organization' => $organization]);
    }

    public function edit(int $story): View
    {
        /** @var Organization $organization */
        $organization = game_engine()->organizationQuery()->findOrFail(game_engine()->user()->current_organization_id);
        $story = $organization->stories()->findOrFail($story);
        $this->authorize('update', $story);

        return view('game-engine::admin.stories.edit', ['organization' => $organization, 'story' => $story]);
    }
}
