@php
    use DefStudio\GameEngine\Models\Run;
    use DefStudio\GameEngine\Decorators\Runs\PlayableStory;
    use DefStudio\GameEngine\Decorators\Runs\PlayableMap;
    use DefStudio\GameEngine\Decorators\Runs\PlayableMission;
    use DefStudio\GameEngine\Decorators\Runs\PlayableTask;

        /** @var Run $run */
@endphp

<x-card>
    @if($isModal)
        <x-slot name="header" class="!bg-gray-200 font-bold uppercase">
            {{__('Run report for :user', ['user' => $run->user->name])}}

            <div wire:click="$emit('closeModal')" class="absolute top-3 right-3 w-6 h-6 rounded-md border shadow bg-gray-50 hover:bg-gray-100 active:bg-gray-200 flex justify-center items-center cursor-pointer">
                <x-icon size="4" name="x"/>
            </div>
        </x-slot>
    @endif

    <div>
        <div>
            {{__('Status')}}:
            @if($run->completed_at)
                {{__('Completed')}}
            @elseif($run->started_at)
                {{__('Ongoing')}}
            @else
                {{__('Not Started')}}
            @endif
        </div>
    </div>

    <x-game-engine::livewire.runs.view.table :run="$run"/>
</x-card>
