<?php

namespace DefStudio\GameEngine\Exceptions;

use Exception;

class LocalizationException extends Exception
{
    public static function missing_translation(string $locale): LocalizationException
    {
        return new self("Missing localization and fallback localization for [$locale] locale");
    }

    public static function not_set_up(string $scope): LocalizationException
    {
        return new self("Storytelling has not been set up for scope [$scope]");
    }
}
