<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Http\Livewire\Teams;

use DefStudio\GameEngine\Models\Team;
use DefStudio\WiredTables\WiredTable;
use Illuminate\Database\Eloquent\Builder;
use DefStudio\GameEngine\Models\Organization;
use DefStudio\GameEngine\Actions\Teams\DeleteTeam;
use Illuminate\Database\Eloquent\Relations\Relation;

class Table extends WiredTable
{
    /** @var Organization */
    public $organization;

    protected function query(): Builder|Relation
    {
        return $this->organization
            ->teams()
            ->with('organization')
            ->withCount(['players', 'masters']);
    }

    protected function columns(): void
    {
        $this->column(__('Name'), 'name')->searchable()->sortable();
        $this->column(trans_choice('Master|Masters', 2), 'masters_count');
        $this->column(trans_choice('Player|Players', 2), 'players_count');
        $this->column(trans_choice('Action|Actions', 2))->view('game-engine::livewire.admin.teams.table.actions');
    }

    public function delete(Team $team): void
    {
        DeleteTeam::run($team);
    }
}
