<?php

namespace DefStudio\GameEngine\Exceptions;

use Exception;
use DefStudio\GameEngine\Enums\Role;

class OrganizationException extends Exception
{
    public static function already_subscribed(): OrganizationException
    {
        return new self('Cannot subscribe a user twice to an organization');
    }

    public static function invalid_role(Role $role): OrganizationException
    {
        $role_label = $role->label();

        return new self("[$role_label] is not a valid role for an organization");
    }

    public static function organization_membership_failure(): OrganizationException
    {
        return new self('User does not belongs to this organization');
    }
}
