// noinspection JSUnresolvedReference,DuplicatedCode

deadline_manager = {
    scopes: {
        map: {
            deadline: null,
            counter_id: null,
        },
        mission:{
            deadline: null,
            counter_id: null,
        },
        task: {
            deadline: null,
            counter_id: null,
        }
    },
    set_timer(alpine, scope){
        alpine.$wire.call(`get_${scope}_deadline`).then(deadline => {
            if (deadline === null) {
                return;
            }

            this.scopes[scope].deadline = new Date(deadline)

            console.debug(`${scope} deadline`, deadline);

            if(this.scopes[scope].counter_id !== null){
                clearTimeout(this.scopes[scope].counter_id)
            }

            this[scope].counter_id = setTimeout(() => this.handle_timeout(alpine, scope), this.scopes[scope].deadline - (new Date()));
        });
    },
    handle_timeout(alpine, scope) {
        console.debug(`time ended for ${scope}!`);

        alpine.$wire.call(`force_${scope}_timeout`);
    }
}

document.addEventListener('alpine:init', () => {
    Alpine.data('map_runner', () => ({
        missions: [],
        current_mission_index: 0,
        size: {w: 0, h: 0, zoom: 1, margins: {top: 0, left: 0}},
        ready: false,
        deadline: null,
        remaining_time: '',

        init() {
            this.$nextTick(() => {
                console.debug('map init');

                this.size.w = this.$refs.background.naturalWidth;
                this.size.h = this.$refs.background.naturalHeight;
                this.update_zoom();
                this.update_missions();
                deadline_manager.set_timer(this, 'map');
            });

            this.$wire.on('mission:activated', () => {
                this.update_missions()
            });
        },
        update_missions() {
            this.$wire.call('current_mission_index').then(index => this.current_mission_index = index);

            this.$wire.call('get_missions').then(missions => {
                this.missions = missions;
                this.ready = true;
            });
        },
        update_zoom() {
            const screen_w = document.documentElement.clientWidth;
            const screen_h = document.documentElement.clientHeight;

            if (screen_w >= this.size.w && screen_h >= this.size.h) {
                this.size.zoom = 1;
                return;
            }

            const zoom_w = screen_w / this.size.w;
            const zoom_h = screen_h / this.size.h;

            this.size.zoom = Math.min(zoom_w, zoom_h);
        },
        is_active(mission_index) {
            if (this.missions[+mission_index].always_active) {
                return true;
            }

            return +this.current_mission_index === +mission_index;
        },
        open_mission(mission_index) {
            if (!this.is_active(mission_index)) {
                return;
            }

            this.$wire.call('start_mission', mission_index);
        }
    }));

    Alpine.data('mission_runner', () => ({
        init(){
            this.$nextTick(() => {
                deadline_manager.set_timer(this,'mission');
                deadline_manager.set_timer(this,'task');
            });
            this.$wire.on('task:activated', () => {
                deadline_manager.set_timer(this,'task');
            });
        },
    }));
})