// noinspection JSUnresolvedReference,DuplicatedCode

/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

// noinspection JSUnresolvedReference,JSUnusedGlobalSymbols

window.drag_and_drop = {
    on_start: [],
    on_complete: [],
    on_abort: [],
};

document.addEventListener('alpine:init', () => {
    Alpine.data('task_multiple_choice_question_run', () => ({
        options: {allow_answer_change: false},
        submitting: false,
        selected_answer: null,

        initialize(config) {
            this.options = config.options;
            this.submitting = false;
            this.selected_answer = null;
        },
        select_answer(answer_id) {
            this.selected_answer = answer_id;

            if (!this.options.allow_answer_change) {
                this.submit();
            }
        },
        submit() {
            this.submitting = true;

            this.$wire.call('complete_task_with_result', {
                answer: this.selected_answer,
            });
        }
    }));

    Alpine.data('task_drag_and_drop_run', () => ({
        size: {w: 0, h: 0, zoom: 1},
        dragging: {mouse_x: null, mouse_y: null},
        snaps: null,
        options: {repositioning_allowed: false, partial_submit_allowed: false, loose_snaps: true},
        tiles_count: null,
        tries_count: 0,
        placements: {},
        submitting: false,
        completed: false,

        initialize(config) {
            this.snaps = config.snaps;
            this.options = config.options;
            this.tiles_count = this.snaps.length;
            this.submitting = false;
            this.completed = false;

            this.$nextTick(() => {
                this.update_zoom();
            });

            drag_and_drop.on_start.forEach(callback => callback());
        },
        update_zoom() {
            this.size.w = this.$refs.base_image.naturalWidth;
            this.size.h = this.$refs.base_image.naturalHeight;

            this.size.real_w = this.$refs.base_image.clientWidth;
            this.size.real_h = this.$refs.base_image.clientHeight;

            const zoom_w = this.size.real_w / this.size.w;
            const zoom_h = this.size.real_h / this.size.h;

            this.size.zoom = Math.min(zoom_w, zoom_h);


            if (!this.size.zoom || this.size.zoom === Infinity) {
                console.log('[drag and drop] zoom = ', this.size.zoom)
                setTimeout(() => this.update_zoom(), 500);
            } else {
                this.size.zoom = Math.floor(this.size.zoom * 100) / 100;
                console.log('[drag and drop] zoom = ', this.size.zoom)
            }
        },
        drag_start(e) {
            this.dragging.mouse_x = e.offsetX * this.size.zoom;
            this.dragging.mouse_y = e.offsetY * this.size.zoom;
            e.dataTransfer.effectAllowed = 'move';
        },
        drag_end(tile_id, e) {
            if (!this.options.repositioning_allowed && this.placements[tile_id]) {
                return;
            }

            const mouse_location = this.get_mouse_drop_location(e);
            if (mouse_location.x < 0 || mouse_location.y < 0 || mouse_location.x > this.size.w || mouse_location.y > this.size.h) {
                if (this.options.repositioning_allowed) {
                    delete this.placements[tile_id];
                    this.$refs.tile_pool.appendChild(e.target);
                }
            }


            const drop_location = this.get_drop_location(e);

            const snap = this.get_snap(drop_location);


            if (!snap && !this.options.loose_snaps) {
                return;
            }

            if (snap && this.is_snap_assigned(snap)) {
                return;
            }


            this.tries_count++;

            this.placements[tile_id] = snap ?? drop_location;

            this.$refs.container.appendChild(e.target);

            if (this.check_complete() && !this.options.repositioning_allowed && !this.options.partial_submit_allowed) {
                this.submit();
            }
        },
        is_snap_assigned(location) {
            for (const [id, placement] of Object.entries(this.placements)) {
                if (placement.x === location.x && placement.y === location.y) {
                    return true;
                }
            }

            return false;
        },
        get_mouse_drop_location(e) {
            const image_offset_x = Math.round(this.$refs.base_image.getBoundingClientRect().left);
            const image_offset_y = Math.round(this.$refs.base_image.getBoundingClientRect().top);

            const mouse_offset_x = e.clientX;
            const mouse_offset_y = e.clientY;

            const drop_x = mouse_offset_x - image_offset_x;
            const drop_y = mouse_offset_y - image_offset_y;

            return {x: drop_x / this.size.zoom, y: drop_y / this.size.zoom}
        },
        get_drop_location(e) {
            const image_offset_x = Math.round(this.$refs.base_image.getBoundingClientRect().left);
            const image_offset_y = Math.round(this.$refs.base_image.getBoundingClientRect().top);

            const drop_offset_x = e.clientX - this.dragging.mouse_x;
            const drop_offset_y = e.clientY - this.dragging.mouse_y;

            const drop_x = drop_offset_x - image_offset_x;
            const drop_y = drop_offset_y - image_offset_y;

            return {x: drop_x / this.size.zoom, y: drop_y / this.size.zoom}
        },
        get_snap(drop_location) {
            return this.snaps.map(snap => {
                const drop_distance = Math.hypot(Math.abs(drop_location.x - snap.x), Math.abs(drop_location.y - snap.y));

                if (drop_distance > snap.distance) {
                    return null;
                }

                snap.drop_distance = drop_distance;
                return snap;
            }).filter(snap => snap !== null)
                .sort((snap_a, snap_b) => snap_a.drop_distance > snap_b.drop_distance ? -1 : 1)
                .shift();
        },
        check_complete() {

            this.completed = this.options.partial_submit_allowed || Object.keys(this.placements).length === this.tiles_count;

            return this.completed;
        },
        submit() {
            drag_and_drop.on_complete.forEach(callback => callback());

            this.submitting = true;
            this.$wire.call('complete_task_with_result', {
                placements: this.placements,
                tries_count: this.tries_count,
            });
        },
        abort() {
            drag_and_drop.on_complete.forEach(callback => callback());
            this.$wire.emit('closeModal');
        }
    }));

    Alpine.data('task_drag_and_drop_configure', () => ({
        size: {w: 0, h: 0, zoom: 1},
        dragging: {mouse_x: null, mouse_y: null},
        init() {
            this.update_zoom();
        },
        update_zoom() {
            const background = this.$refs.configuration_main.querySelector('#base-image-preview');

            if (!background) {
                setTimeout(() => this.update_zoom(), 1000);
                this.size.zoom = 0;
                return;
            }

            this.size.w = background.naturalWidth;
            this.size.h = background.naturalHeight;

            this.size.real_w = background.clientWidth;
            this.size.real_h = background.clientHeight;

            const zoom_w = this.size.real_w / this.size.w;
            const zoom_h = this.size.real_h / this.size.h;

            this.size.zoom = Math.min(zoom_w, zoom_h);

            console.log('[drag and drop] zoom = ', this.size.zoom)

            if (!this.size.zoom || this.size.zoom === Infinity) {
                console.log('[drag and drop] zoom = ', this.size.zoom)
                setTimeout(() => this.update_zoom(), 500);
            } else {
                this.size.zoom = Math.floor(this.size.zoom * 100) / 100;
                console.log('[drag and drop] zoom = ', this.size.zoom)
            }
        },
        drag_start(index, e) {
            this.dragging.mouse_x = e.offsetX;
            this.dragging.mouse_y = e.offsetY;
            e.dataTransfer.effectAllowed = 'move';
        },
        drag_end(index, e) {
            const offset_x = e.offsetX - this.dragging.mouse_x;
            const offset_y = e.offsetY - this.dragging.mouse_y;

            console.log('move', offset_x, offset_y);
            this.$wire.call('move_tile_placeholder', index, offset_x, offset_y);
        }
    }));
});
