@php
    use DefStudio\GameEngine\Http\Livewire\Runs\Runner;
    use DefStudio\GameEngine\Enums\MediaCollection;
    use DefStudio\GameEngine\Decorators\Runs\PlayableMission;
    use DefStudio\GameEngine\Enums\StorytellingType;

    /** @var Runner $this */
@endphp

@if($this->current_map_index() >= 0)
    <x-game-engine::runs.map.box class="flex justify-center items-center">

        <div x-data="map_runner" class="relative min-w-fit" :style="{zoom: size.zoom, width: size.w+'px', height: size.h+'px'}" @resize.window="update_zoom" x-show="ready" x-cloak>
            <img src="{{$this->map->background()}}" x-ref="background">


            <template x-for="(mission, mission_index) in missions" :key="mission.id">
                <template x-if="mission.placeholder_image">
                    <img class="absolute"
                         :class="{
                            'cursor-pointer': is_active(mission_index),
                            @feature(\DefStudio\GameEngine\Enums\Feature::pulse_active_missions)'animate-pulse': is_active(mission_index)@endfeature
                            @feature(\DefStudio\GameEngine\Enums\Feature::bounce_active_missions)'animate-bounce': is_active(mission_index)@endfeature
                         }"
                         :style="{top: mission.pos_y+'px', left: mission.pos_x+'px'}"
                         :src="mission.placeholder_image"
                         x-show="mission.visible"
                         @click="open_mission(mission_index)"
                    >
                </template>
            </template>
        </div>


    </x-game-engine::runs.map.box>
@endif
