@props(['storytellings'])

@php
    use DefStudio\GameEngine\Models\Storytelling;
    use Illuminate\Database\Eloquent\Collection;
    /** @var Collection<int, Storytelling> $storytellings */
@endphp

<div x-data="storytelling_runner" x-init="setup('{{$storytellings->first()->target_type}}', '{{$storytellings->first()->type->value}}', {{$storytellings->count()}})">

    <x-game-engine::runs.storytelling.box {{$attributes}}>
        @foreach($storytellings as $storytelling)
            <template x-if="current === {{$loop->iteration}}">
                <div class="relative grow flex flex-col {{$storytelling->target_type}}-{{$storytelling->type->value}}-storytelling">

                    @php($background = $storytelling->background())
                    @php($avatar = $storytelling->avatar())

                    @if($background)
                        <img src="{{$background}}" class="rounded-md">
                    @endif

                    <div class="absolute bottom-0 right-0 left-0 flex px-2">
                        @if($avatar && $storytelling->avatar_position === 'left')
                            <x-game-engine::runs.storytelling.avatar :avatar="$avatar"/>
                        @endif

                        <x-game-engine::runs.storytelling.text class="mt-auto mb-2 grow">
                            <div class="ck-content">
                                {!! $storytelling->localized_text() !!}
                            </div>

                            <x-game-engine::runs.elements.button-primary x-show="type !== 'pause'"
                                                                         @click="next()"
                                                                         @keyup.enter.window="next()"
                                                                         x-bind:class="{'opacity-50': closing}"
                                                                         x-bind:disabled="closing"
                                                                         class="ml-auto">
                                {{__('Next')}}
                            </x-game-engine::runs.elements.button-primary>

                        </x-game-engine::runs.storytelling.text>

                        @if($avatar && $storytelling->avatar_position === 'right')
                            <x-game-engine::runs.storytelling.avatar :avatar="$avatar"/>
                        @endif
                    </div>
                </div>
            </template>
        @endforeach
    </x-game-engine::runs.storytelling.box>
</div>

