<?php
/** @var \DefStudio\GameEngine\Models\Run $model */
?>

<div class="flex">
    <x-game-engine::livewire.runs.table.extra-actions :run="$model"/>
    @if($model->completed_at)
        @can('view', $model)
            <x-link class="mr-2" size="sm" color="secondary" icon="eye"
                    href="{{route('game-engine.admin.runs.show', $model->id)}}"
            />
        @endcan
    @endif
    @can('delete', $model)
        <x-confirm-action title="Warning"
                          :content="__('Do you really want to delete this run?')"
                          :requires-password="true"
                          wire:then="delete({{$model->id}})"
                          class="ml-auto"
        >
            <x-button icon="trash" color="secondary" size="sm"/>
        </x-confirm-action>
    @endcan
</div>
