@php
    use DefStudio\GameEngine\Enums\Permission;
    use DefStudio\GameEngine\Enums\Role;
@endphp
<x-card>
    <div @class([
            "grid grid-cols-1",
            'gap-6' => $editing
        ])>
        <div @class([
            "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 ",
            'gap-6' => $editing
        ])>
            @if($editing)
                <x-checkbox model="published" defer :label="__('Published')"/>
            @else
                @if($published)
                    {{__('Published')}}
                @else
                    {{__('Unpublished')}}
                @endif
            @endif

        </div>

        @feature(\DefStudio\GameEngine\Enums\Feature::global_stories)
        <div @class([
            "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 ",
            'gap-6' => $editing
        ])>
            @if($editing)
                <x-checkbox model="global" defer :label="__('Global Story')"/>
            @else
                @if($global)
                    {{__('Global Story')}}
                @else
                    {{__('Organization Story')}}
                @endif
            @endif

        </div>
        @endfeature

        <div @class([
            "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 ",
            'gap-6' => $editing
        ])>
            @if($editing)
                <x-text model="story.title" defer :label="__('Title')"/>
                <x-text-area class="col-span-1 lg:col-span-3" model="story.description" defer :label="__('Description')"/>

                <x-game-engine::livewire.image_field
                    id="cover-image"
                    model="cover_image"
                    class="col-span-1 md:col-span-2 lg:col-span-3"
                    :label="$story->exists ? __('Replace Cover Image') : __('Cover Image')"
                    :helper="__('SVG, PNG or JPG')"
                    :uploaded-url="$story->getFirstMediaUrl(\DefStudio\GameEngine\Enums\MediaCollection::cover)"
                    remove-method="remove_cover_image"
                />
            @else
                <h2 class="text-xl text-gray-700">{{$story->title}}</h2>
                <div class="text-gray-500 col-span-1 lg:col-span-3">{{$story->description}}</div>
            @endif
        </div>
    </div>


    <x-slot name="actions">


        @if($editing)
            <x-button class="mr-auto" wire:loading.disable color="secondary" wire:click="$set('editing', false)">{{__('Abort')}}</x-button>
            <x-button wire:loading.disable wire:click="save">{{__('Save')}}</x-button>
        @else
            <x-button wire:loading.disable wire:click="$set('editing', true)" color="secondary">{{__('Edit')}}</x-button>
        @endif
    </x-slot>
</x-card>
