<?php

use DefStudio\GameEngine\Enums\Role;
use DefStudio\GameEngine\Models\User;
use DefStudio\GameEngine\Models\Team;

/** @var User $model */
?>

@php($organization_role = $model->get_role_in_organization(game_engine()->user()->current_organization))
<span @class([
        "rounded text-black {$organization_role->color()} px-2 py-1 text-xs font-bold mr-3",
        'opacity-20' => !$model->belongs_to_team($team),
      ])>
    {{$organization_role->label()}}
</span>
