<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

namespace DefStudio\GameEngine\Decorators\Runs;

use Illuminate\Support\Collection;
use DefStudio\GameEngine\Models\Map;
use DefStudio\GameEngine\Models\Story;

/**
 * @extends PlayableActivity<Story>
 *
 * @mixin Story
 */
class PlayableStory extends PlayableActivity
{
    public static string $state_key = 'stories';

    protected function setup_decorator(): void
    {
        $this->model->loadMissing(['storytellings', 'maps']);
    }

    /**
     * @return Collection<int, PlayableMap>
     */
    public function playable_maps(): Collection
    {
        return $this->maps
            ->sortBy('order')
            ->each(fn(Map|PlayableMap $map) => $map->setRelation('story', $this->model))
            ->map(fn(Map|PlayableMap $map) => PlayableMap::build($map)->setup($this->run));
    }

    public function current_playable_map(): ?PlayableMap
    {
        return $this->playable_maps()->values()->get($this->run->get_state('current_map', -1)) ?? null;
    }

    public function completed(): bool
    {
        return $this->playable_maps()->every(fn(PlayableMap $map) => $map->completed());
    }
}
