<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

namespace DefStudio\GameEngine;

use Illuminate\Contracts\Http\Kernel;
use Spatie\LaravelPackageTools\Package;
use DefStudio\GameEngine\Views\Components\Editor;
use DefStudio\GameEngine\Middleware\SetUserLocale;
use DefStudio\GameEngine\Commands\SyncRolesCommand;
use Spatie\LaravelPackageTools\PackageServiceProvider;
use DefStudio\GameEngine\Commands\MakeSuperAdminCommand;
use DefStudio\GameEngine\Commands\RebuildSnapshotsCommand;
use DefStudio\GameEngine\Commands\SyncTranslationsCommand;

class GameEngineServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        $package
            ->name('game-engine')
            ->hasConfigFile()
            ->hasAssets()
            ->hasViews()
            ->hasViewComponent('', Editor::class)
            ->hasMigrations([
                'add_locale_to_users',
                'create_organizations_table',
                'create_organization_user_table',
                'add_current_organization_id_to_users',
                'create_teams_table',
                'create_team_user_table',
                'create_stories_table',
                'create_story_subscriptions_table',
                'create_maps_table',
                'create_media_table',
                'create_missions_table',
                'create_tasks_table',
                'create_storytellings_table',
                'create_awards_table',
                'create_runs_table',
                'create_runs_table',
                'add_configuration_to_maps',
                'add_debug_to_runs',
                'global_stories',
                'create_run_data_table',
                'migrate_to_run_data_table',
                'remove_data_from_runs_table',
            ])
            ->hasRoutes('web')
            ->hasCommand(RebuildSnapshotsCommand::class)
            ->hasCommand(SyncRolesCommand::class)
            ->hasCommand(MakeSuperAdminCommand::class)
            ->hasCommand(SyncTranslationsCommand::class);
    }

    public function packageRegistered(): void
    {
        /** @var \Illuminate\Foundation\Http\Kernel $kernel */
        $kernel = $this->app->make(Kernel::class);
        $kernel->appendMiddlewareToGroup('web', SetUserLocale::class);
    }
}
