<?php

namespace DefStudio\GameEngine\Http\Livewire\Runs;

use Illuminate\Contracts\View\View;
use LivewireUI\Modal\ModalComponent;
use Illuminate\Database\Eloquent\Collection;
use DefStudio\GameEngine\Models\Storytelling;
use DefStudio\GameEngine\Http\Livewire\Concerns\ImprovedModal;
use DefStudio\GameEngine\Http\Livewire\Runs\Concerns\RetrievesActivities;

/**
 * @property-read Collection<int, Storytelling> $storytellings
 */
class StorytellingModal extends ModalComponent
{
    use ImprovedModal;
    use RetrievesActivities;

    public int $run_id;

    public string $scope;

    public string $type;

    public array $storytelling_ids;

    protected static array $maxWidths = [
        'sm' => 'sm:max-w-sm',
        'md' => 'sm:max-w-md',
        'lg' => 'sm:max-w-md md:max-w-lg',
        'xl' => 'sm:max-w-md md:max-w-xl',
        '2xl' => 'sm:max-w-md md:max-w-xl lg:max-w-2xl',
        '3xl' => 'sm:max-w-md md:max-w-xl lg:max-w-3xl',
        '4xl' => 'sm:max-w-md md:max-w-xl lg:max-w-3xl xl:max-w-4xl',
        '4xl+' => 'sm:max-w-2xl md:max-w-3xl lg:max-w-4xl xl:max-w-4xl',
        '5xl' => 'sm:max-w-md md:max-w-xl lg:max-w-3xl xl:max-w-5xl',
        '6xl' => 'sm:max-w-md md:max-w-xl lg:max-w-3xl xl:max-w-5xl 2xl:max-w-6xl',
        '7xl' => 'sm:max-w-md md:max-w-xl lg:max-w-3xl xl:max-w-5xl 2xl:max-w-7xl',
    ];

    public static function modalMaxWidth(): string
    {
        return '4xl+';
    }

    public function render(): View
    {
        return view('game-engine::livewire.runs.storytelling-modal');
    }

    public function getStorytellingsProperty(): Collection
    {
        return Storytelling::findMany($this->storytelling_ids);
    }

    public function complete(): void
    {
        $this->emit('complete_storytelling', $this->scope, $this->type, !$this->isModal);
    }

    public function is_paused(): bool
    {
        return $this->run->is_paused() !== false;
    }
}
