@php
    use DefStudio\GameEngine\Http\Livewire\Runs\Concerns\RunsTasks;
    use DefStudio\GameEngine\Decorators\Runs\PlayableTask;
    use DefStudio\GameEngine\Decorators\Tasks\MultipleChoiceQuestion;

    /** @var RunsTasks $this */

    /** @var PlayableTask&MultipleChoiceQuestion $task */
    $task = $this->task;

    if(empty($task->get_state('available_answers'))){
        $answers = $task->answers();

        if($task->should_randomize_answers_order()){
            $answers = collect($answers)->shuffle()->toArray();
        }

        $task->set_state('available_answers', $answers);
    }
@endphp

<div x-data="task_multiple_choice_question_run"
     x-init="initialize({options: {{json_encode($task->run_options())}}})"
>
    <div class="ck-content">
        {!! localize($task->question()) !!}
    </div>

    <div class="my-4 px-8 flex justify-center gap-2" wire:ignore wire:key="task-answers-{{$task->id}}">
        @foreach($task->get_state('available_answers') as $answer)
            <x-game-engine::tasks.multiple-choice-question.answer-button
                @click="select_answer('{{$answer['id']}}')"

                x-bind:class="{'bg-gray-200': selected_answer === '{{$answer['id']}}'}"
                x-bind:disabled="submitting || selected_answer === '{{$answer['id']}}'"
            >
                {!! localize($answer['answer']) !!}
            </x-game-engine::tasks.multiple-choice-question.answer-button>
        @endforeach
    </div>

    <div class="flex mb-4">
        @if($task->allows_answer_change())
            <x-game-engine::tasks.drag-and-drop.submit-button @click="submit"
                                                              class="ml-auto"
                                                              x-bind:class="{'opacity-50': submitting || !selected_answer}"
                                                              x-bind:disabled="submitting || !selected_answer"
            >{{__('Submit answer')}}</x-game-engine::tasks.drag-and-drop.submit-button>
        @endif
    </div>
</div>
