// noinspection JSUnresolvedReference

document.addEventListener('alpine:init', () => {
    Alpine.data('map_runner', () => ({
        missions: [],
        current_mission_index: 0,
        size: {w: 0, h: 0, zoom: 1, margins: {top: 0, left: 0}},
        ready: false,
        deadline: null,
        remaining_time: '',

        init() {
            this.$nextTick(() => {
                console.debug('map init');

                this.size.w = this.$refs.background.naturalWidth;
                this.size.h = this.$refs.background.naturalHeight;
                this.update_zoom();
                this.update_missions();
                this.set_timer();
            });

            this.$wire.on('mission:activated', () => {
                this.update_missions()
            });
        },
        set_timer() {
            console.log('setting up timer');

            this.$wire.call('get_map_deadline').then(deadline => {
                if (deadline === null) {
                    return;
                }

                this.deadline = new Date(deadline)

                console.debug('map deadline', deadline);

                setTimeout(() => this.handle_timeout(), this.deadline - (new Date()));
                setInterval(() => this.update_countdown(), 1000);
            });
        },
        handle_timeout() {
            console.debug('time ended for map!');
            this.$wire.call('force_map_timeout');
        },
        update_countdown(){
            if(this.deadline === undefined){
                this.remaining_time = 'no timer';
                return;
            }

            const remaining_time = this.deadline.getTime() - (new Date()).getTime();

            const minutes = Math.floor((remaining_time % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((remaining_time % (1000 * 60)) / 1000);

            this.remaining_time = `${minutes}m ${seconds}s`;
        },
        update_missions() {
            this.$wire.call('current_mission_index').then(index => this.current_mission_index = index);

            this.$wire.call('get_missions').then(missions => {
                this.missions = missions;
                this.ready = true;
            });
        },
        update_zoom() {
            const screen_w = document.documentElement.clientWidth;
            const screen_h = document.documentElement.clientHeight;

            if (screen_w >= this.size.w && screen_h >= this.size.h) {
                this.size.zoom = 1;
                return;
            }

            const zoom_w = screen_w / this.size.w;
            const zoom_h = screen_h / this.size.h;

            this.size.zoom = Math.min(zoom_w, zoom_h);
        },
        is_active(mission_index) {
            if (this.missions[+mission_index].always_active) {
                return true;
            }

            return +this.current_mission_index === +mission_index;
        },
        open_mission(mission_index) {
            if (!this.is_active(mission_index)) {
                return;
            }

            this.$wire.call('start_mission', mission_index);
        }
    }));

    Alpine.data('mission_runner', () => ({
        deadline: null,
        remaining_time: '',
        init(){
            this.$nextTick(() => this.set_timer());
        },
        set_timer(){
            this.$wire.call('get_mission_deadline').then(deadline => {
                if (deadline === null) {
                    return;
                }

                this.deadline = new Date(deadline)

                console.debug('mission deadline', deadline);

                setTimeout(() => this.handle_timeout(), this.deadline - (new Date()));
                setInterval(() => this.update_countdown(), 1000);
            });
        },
        handle_timeout() {
            console.debug('time ended for mission!');
            this.$wire.call('force_mission_timeout');
        },
        update_countdown(){
            if(this.deadline === undefined){
                this.remaining_time = 'no timer';
                return;
            }

            const remaining_time = this.deadline.getTime() - (new Date()).getTime();

            const minutes = Math.floor((remaining_time % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((remaining_time % (1000 * 60)) / 1000);

            this.remaining_time = `${minutes}m ${seconds}s`;
        },
    }));
})