<?php

namespace DefStudio\GameEngine\Actions\Missions;

use DefStudio\Actions\Action;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\Mission;
use DefStudio\GameEngine\Events\Missions\MissionDeleted;
use DefStudio\GameEngine\Events\Missions\DeletingMission;

/**
 * @method static void run(Mission $mission = null)
 */
class DeleteMission extends Action
{
    public function handle(Mission $mission): void
    {
        Gate::authorize('delete', $mission);

        DB::transaction(function() use ($mission): void {
            DeletingMission::dispatch($mission);

            $mission->delete();

            MissionDeleted::dispatch($mission);
        });
    }
}
