<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Actions\Missions;

use DefStudio\Actions\Action;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\Mission;
use DefStudio\GameEngine\Enums\MediaCollection;
use DefStudio\GameEngine\Events\Missions\MissionCoverImageUpdated;

/**
 * @method static void run(Mission $mission, UploadedFile $cover_image_file)
 */
class StoreCoverImage extends Action
{
    public function handle(Mission $mission, UploadedFile $cover_image_file): void
    {
        Gate::authorize('update', $mission);

        $mission->addMedia($cover_image_file)
            ->toMediaCollection(MediaCollection::cover->name);

        MissionCoverImageUpdated::dispatch($mission);
    }
}
