<?php

namespace DefStudio\GameEngine\Enums;

enum StorytellingType: string
{
    case activation = 'activation';
    case prologue = 'prologue';
    case epilogue = 'epilogue';
    case timeout = 'timeout';

    public function label(): string
    {
        return match ($this) {
            self::activation => __('Activation'),
            self::prologue => __('Prologue'),
            self::epilogue => __('Epilogue'),
            self::timeout => __('Timeout'),
        };
    }

    public static function build_from(StorytellingType|string $storytelling_type): StorytellingType
    {
        if ($storytelling_type instanceof StorytellingType) {
            return $storytelling_type;
        }

        return StorytellingType::from($storytelling_type);
    }
}
