@props(['image' => null, 'large' => false, 'shadow' => true, 'bgcolor' => "bg-gray-200"])

@php
    /** @var \Spatie\MediaLibrary\MediaCollections\Models\Media|null $image */
@endphp

<div {{$attributes->class(["flex pr-2 py-1", "shadow" => $shadow])}}>
    <div @class(["-my-1 mr-2 flex items-center $bgcolor", "w-8 px-2" => $large, "w-4" => !$large])>
        @if($image)
            {{$image->img(\DefStudio\GameEngine\Enums\MediaConversion::thumb->name)}}
        @endif
    </div>
    {{$slot}}
</div>
