<?php

namespace DefStudio\GameEngine\Enums;

use Countable;

enum Role: string
{
    case super_admin = 'super_admin';
    case admin = 'admin';
    case master = 'master';
    case player = 'player';

    public function label(array|Countable|int $count = 1): string
    {

        return match ($this) {
            self::super_admin => trans_choice('Super Admin|Super Admins', $count),
            self::admin => trans_choice('Admin|Admins', $count),
            self::master => trans_choice('Master|Masters', $count),
            self::player => trans_choice('Player|Players', $count),
        };
    }

    public function color(): string
    {
        return config('game-engine.users.roles.'.$this->value.'.color');
    }
}
