<?php

/** @noinspection PhpUndefinedMethodInspection */

namespace DefStudio\GameEngine\Database\Factories;

use DefStudio\GameEngine\Enums\MediaCollection;
use Illuminate\Database\Eloquent\Factories\Factory;
use DefStudio\GameEngine\Database\Factories\Concerns\HasMedia;
use DefStudio\GameEngine\Database\Factories\Concerns\DefinesAwards;
use DefStudio\GameEngine\Database\Factories\Concerns\HasStorytelling;

class MissionFactory extends Factory
{
    use HasMedia;
    use HasStorytelling;
    use DefinesAwards;

    public function modelName(): string
    {
        return \game_engine()->missionClass();
    }

    public function definition(): array
    {
        return [
            'title' => fake()->sentence,
            'description' => fake()->text,
            'map_id' => game_engine()->mapClass()::factory(),
            'pos_x' => fake()->numberBetween(0, 1024),
            'pos_y' => fake()->numberBetween(0, 1080),
        ];
    }

    public function with_cover_image(string $path = null): MissionFactory
    {
        return $this->with_media(MediaCollection::cover, $path);
    }

    public function with_placeholder_image(string $path = null): MissionFactory
    {
        return $this->with_media(MediaCollection::placeholder, $path);
    }
}
