<?php

use DefStudio\GameEngine\Enums\Role;
use DefStudio\GameEngine\Models\User;
use DefStudio\GameEngine\Models\Team;

/** @var \DefStudio\GameEngine\Models\Story $model */
/** @var Team $team */
?>

<div class="flex">
    @can('update', $team)
        @if($team->is_subscribed_to_story($model))
            <x-button class="ml-auto" color="secondary" wire:click="unsubscribe({{$model->id}})" wire:loading.disable>{{__('Unsubscribe')}}</x-button>
        @else
            <x-button class="ml-auto" wire:click="subscribe({{$model->id}})" wire:loading.disable>{{__('Subscribe')}}</x-button>
        @endif
    @endcan
</div>
