<?php

namespace DefStudio\GameEngine\Actions\Organizations;

use DefStudio\Actions\Action;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\Organization;
use DefStudio\GameEngine\Events\Organizations\OrganizationDeleted;
use DefStudio\GameEngine\Events\Organizations\DeletingOrganization;

/**
 * @method static void run(Organization $organization)
 */
class DeleteOrganization extends Action
{
    public function handle(Organization $organization): void
    {
        Gate::authorize('delete', $organization);

        DB::transaction(function() use ($organization): void {
            DeletingOrganization::dispatch($organization);

            $organization->delete();

            OrganizationDeleted::dispatch($organization);
        });

    }
}
