<?php

namespace DefStudio\GameEngine\Http\Livewire\Concerns;

trait RedirectsBack
{
    public string|null $back_url = null;

    public function mountRedirectsBack(): void
    {
        $this->back_url ??= \game_engine()->back_url();
    }

    public function redirect_back(): void
    {
        $this->redirect($this->back_url ?? '/');
    }

    public function reflash_back_url(): void
    {
        game_engine()->flash_back_url($this->back_url);
    }
}
