<?php

namespace DefStudio\GameEngine\Policies;

use DefStudio\GameEngine\Models\User;
use DefStudio\GameEngine\Models\Mission;
use Illuminate\Auth\Access\HandlesAuthorization;

class MissionPolicy
{
    use HandlesAuthorization;

    public function view(User $user, Mission $target): bool
    {
        return $user->can('view', $target->map);
    }

    public function save(User $user, Mission $target): bool
    {
        if ($target->exists) {
            return $this->update($user, $target);
        }

        return $this->create($user, $target);
    }

    public function create(User $user, Mission $target): bool
    {
        return $user->can('update', $target->map);
    }

    public function update(User $user, Mission $target): bool
    {
        return $user->can('update', $target->map);
    }

    public function delete(User $user, Mission $target): bool
    {
        return $user->can('update', $target->map);
    }
}
