<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

namespace DefStudio\GameEngine\Http\Livewire\Users;

use Livewire\Component;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use DefStudio\GameEngine\Models\User;

class ResetPassword extends Component
{
    public int $user_id;

    public string $password = '';

    public string $password_confirmation = '';

    public function rules(): array
    {
        /** @noinspection PhpUndefinedMethodInspection */
        return [
            'password' => [
                'required',
                'confirmed',
                game_engine()->userClass()::password_rules(),
            ],
        ];
    }

    public function render(): View
    {
        return view('game-engine::livewire.users.reset_password');
    }

    public function save(): void
    {
        $this->validate();

        /** @var User $user */
        $user = game_engine()->userQuery()->findOrFail($this->user_id);

        $user->password = Hash::make($this->password);

        $user->save();

        if (!Auth::check()) {
            Auth::login($user);
        }

        $this->redirect(route(config('game-engine.users.reset_password.redirect_to_route')));
    }
}
