<?php

namespace DefStudio\GameEngine\Listeners\Maps;

use DefStudio\GameEngine\Models\Mission;
use DefStudio\GameEngine\Events\Maps\DeletingMap;
use DefStudio\GameEngine\Actions\Missions\DeleteMission;

class DeletingMapListener
{
    public function handle(DeletingMap $event): void
    {
        $event->map->loadMissing('missions.tasks');

        $event->map->missions->each(fn(Mission $mission) => DeleteMission::run($mission));
    }
}
