<x-app-layout>
    <x-slot name="header">
        {{ __('Dashboard') }}
    </x-slot>

    @php($user = game_engine()->user())

    <x-container>
        @if(!$user->current_organization_id)
            {{__('You must choose an Organization in order to see available stories')}}
        @else
            @php($stories = $user->available_stories())

            @if($stories->isEmpty())
                {{__('You are not subscribed to any story in this Organization, yet')}}
            @else

                <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4">
                    @foreach($stories as $story)
                        <x-game-engine::stories.card :story=" $story"/>
                    @endforeach
                </div>
            @endif
        @endif
    </x-container>
</x-app-layout>
