<?php

namespace DefStudio\GameEngine\Http\Livewire\Concerns;

use ReflectionClass;

trait CallsTraitsMethods
{
    protected function call_traits_method(string $method, mixed ...$args): void
    {
        $reflection = new ReflectionClass($this);
        foreach ($reflection->getTraitNames() as $trait) {
            $trait = class_basename($trait);

            $trait_method = $method.$trait;

            if (method_exists($this, $trait_method)) {
                $this->{$trait_method}(...$args);

                continue;
            }

            $trait_method = $method.'_'.str($trait)->snake()->toString();

            if (method_exists($this, $trait_method)) {
                $this->{$trait_method}(...$args);
            }
        }
    }
}
