<?php

namespace DefStudio\GameEngine\Exceptions;

use Exception;
use DefStudio\GameEngine\Models\Contracts\AwardsDefiner;

class AwardException extends Exception
{
    public static function invalid_scope(string $scope_class): AwardException
    {
        return new self("Scope [$scope_class] must implement ".AwardsDefiner::class);
    }

    public static function not_found($award_id): AwardException
    {
        return new AwardException("Award #$award_id not found");
    }
}
