<?php /** @var \DefStudio\GameEngine\Models\Team $model */ ?>

<div class="flex">
    @can('update', $model)
        @php($route = route('game-engine.admin.teams.edit', ['team' => $model]))
        <x-link icon="pencil" color="secondary" size="sm" :href="$route"/>
    @endcan
    @can('delete', $model)
        <x-confirm-action class="ml-auto" title="Warning"
                          :content="__('Do you really want to delete this team?')"
                          :requires-password="true"
                          wire:then="delete({{$model->id}})"
        >
            <x-button icon="trash" color="secondary" size="sm"/>
        </x-confirm-action>
    @endcan
</div>
