<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }} - {{$run->story->title}}</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet"/>

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <!-- Styles -->
    @livewireStyles

    <x-game-engine::runner-styles/>
</head>
<body class="font-sans antialiased">

<main class="min-h-screen bg-gray-100  flex justify-center items-center">
    <livewire:game-engine.runner :run_id="$run->id"/>
</main>

<!-- Modals -->
@stack('modals')

<!-- Livewire -->
@livewire('livewire-ui-modal')
@livewireScripts

<x-game-engine::runner-scripts/>

</body>
</html>
