<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

/** @noinspection PhpMissingFieldTypeInspection */

namespace DefStudio\GameEngine\Decorators\Tasks;

use DefStudio\GameEngine\Models\Task;
use DefStudio\GameEngine\Enums\MediaCollection;
use DefStudio\GameEngine\Http\Livewire\Tasks\Edit;
use DefStudio\GameEngine\Decorators\ModelDecorator;

/**
 * @extends ModelDecorator<Task>
 *
 * @mixin Task
 */
abstract class TaskDecorator extends ModelDecorator
{
    protected array $media_collections = [];

    abstract public static function type_label(): string;

    abstract public static function configuration_component(): string;

    abstract public static function run_component(): string;

    abstract public function is_complete(array $state): bool;

    /**
     * @return array<int, float>
     */
    abstract public function get_awards_for_run(array $state): array;

    public function process_completion(array $state): array
    {
        return $state;
    }

    protected function setup_decorator(): void
    {
        collect($this->media_collections)->each(fn(MediaCollection $collection) => $this->model->enable_media_collection($collection));
    }

    public function saving_from_livewire_editor(Edit $edit): void
    {
        //..
    }

    public function snapshot(): array
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'order' => $this->order,
            'type' => $this->type,
            'type_label' => static::type_label(),
            'configuration' => $this->configuration->toArray(), // @phpstan-ignore-line
        ];
    }
}
