<?php

namespace DefStudio\GameEngine\Exceptions;

use Exception;

class StorytellingException extends Exception
{
    public static function must_be_bound_to_a_target(): StorytellingException
    {
        return new self('New storytellings need a task to be bound to');
    }

    public static function not_set_up(string $scope): StorytellingException
    {
        return new self("Storytelling has not been set up for scope [$scope]");
    }
}
