<?php

namespace DefStudio\GameEngine\Listeners\Stories;

use DefStudio\GameEngine\Models\Map;
use DefStudio\GameEngine\Actions\Maps\DeleteMap;
use DefStudio\GameEngine\Events\Stories\DeletingStory;

class DeletingStoryListener
{
    public function handle(DeletingStory $event): void
    {
        $event->story->loadMissing('maps.missions.tasks');
        $event->story->maps->each(fn(Map $map) => DeleteMap::run($map));
    }
}
