// noinspection JSUnresolvedReference

/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

// noinspection JSUnresolvedReference,JSUnusedGlobalSymbols

window.drag_and_drop = {
    on_start: [],
    on_complete: [],
};

document.addEventListener('alpine:init', () => {
    Alpine.data('task_multiple_choice_question_run', () => ({
        options: {allow_answer_change: false},
        submitting: false,
        selected_answer: null,

        initialize(config) {
            this.options = config.options;
        },
        select_answer(answer_id) {
            this.selected_answer = answer_id;

            if (!this.options.allow_answer_change) {
                this.submit();
            }
        },
        submit() {
            this.submitting = true;

            this.$wire.call('complete_task_with_result', {
                answer: this.selected_answer,
            });
        }
    }));

    Alpine.data('task_drag_and_drop_run', () => ({
        size: {w: 0, h: 0, zoom: 1},
        dragging: {mouse_x: null, mouse_y: null},
        snaps: null,
        options: {repositioning_allowed: false, partial_submit_allowed: false, loose_snaps: true},
        tiles_count: null,
        tries_count: 0,
        placements: {},
        submitting: false,
        initialize(config) {
            this.snaps = config.snaps;
            this.options = config.options;
            this.tiles_count = this.snaps.length;

            this.$nextTick(() => {
                this.update_zoom();
            });

            drag_and_drop.on_start.forEach(callback => callback());
        },
        update_zoom() {
            this.size.w = this.$refs.base_image.naturalWidth;
            this.size.h = this.$refs.base_image.naturalHeight;

            this.size.real_w = this.$refs.base_image.clientWidth;
            this.size.real_h = this.$refs.base_image.clientHeight;

            const zoom_w = this.size.real_w / this.size.w;
            const zoom_h = this.size.real_h / this.size.h;

            this.size.zoom = Math.min(zoom_w, zoom_h);


            if (!this.size.zoom || this.size.zoom === Infinity) {
                console.log('[drag and drop] zoom = ', this.size.zoom)
                setTimeout(() => this.update_zoom(), 500);
            } else {
                this.size.zoom = Math.floor(this.size.zoom * 100) / 100;
                console.log('[drag and drop] zoom = ', this.size.zoom)
            }
        },
        drag_start(e) {
            this.dragging.mouse_x = e.offsetX * this.size.zoom;
            this.dragging.mouse_y = e.offsetY * this.size.zoom;
            e.dataTransfer.effectAllowed = 'move';
        },
        drag_end(tile_id, e) {
            if (!this.options.repositioning_allowed && this.placements[tile_id]) {
                return;
            }

            const drop_location = this.get_drop_location(e);
            const snap = this.get_snap(drop_location);

            if (!snap && !this.options.loose_snaps) {
                return;
            }

            this.tries_count++;

            this.placements[tile_id] = snap ?? drop_location;

            this.$refs.container.appendChild(e.target);

            if (this.check_complete()) {
                this.submit();
            }
        },
        get_drop_location(e) {
            const image_offset_x = Math.round(this.$refs.base_image.getBoundingClientRect().left);
            const image_offset_y = Math.round(this.$refs.base_image.getBoundingClientRect().top);

            const drop_offset_x = e.clientX - this.dragging.mouse_x;
            const drop_offset_y = e.clientY - this.dragging.mouse_y;

            const drop_x = drop_offset_x - image_offset_x;
            const drop_y = drop_offset_y - image_offset_y;

            return {x: drop_x / this.size.zoom, y: drop_y / this.size.zoom}
        },
        get_snap(drop_location) {
            return this.snaps.map(snap => {
                const drop_distance = Math.hypot(Math.abs(drop_location.x - snap.x), Math.abs(drop_location.y - snap.y));

                if (drop_distance > snap.distance) {
                    return null;
                }

                snap.drop_distance = drop_distance;
                return snap;
            }).filter(snap => snap !== null)
                .sort((snap_a, snap_b) => snap_a.drop_distance > snap_b.drop_distance ? -1 : 1)
                .shift();
        },
        check_complete() {
            return Object.keys(this.placements).length === this.tiles_count;
        },
        submit() {
            drag_and_drop.on_complete.forEach(callback => callback());

            this.submitting = true;
            this.$wire.call('complete_task_with_result', {
                placements: this.placements,
                tries_count: this.tries_count,
            });
        },
    }));
});
