<?php

use DefStudio\GameEngine\Enums\Role;
use DefStudio\GameEngine\Models\User;
use DefStudio\GameEngine\Models\Team;

/** @var User $model */
?>

<div class="flex">
    @can('update', $model)
        <x-link icon="pencil" color="secondary" size="sm" :href="route('game-engine.admin.users.edit', $model)"/>
    @endcan

    <x-game-engine::impersonate :user="$model"/>

    @can('delete', $model)
        <x-confirm-action class="ml-auto" title="Warning"
                          :content="__('Do you really want to remove this user from organization?')"
                          :requires-password="true"
                          wire:then="detach_user({{$model->id}})"
        >
            <x-button icon="trash" color="secondary" size="sm"/>
        </x-confirm-action>
    @endcan
</div>
