<?php

namespace DefStudio\GameEngine\Actions\Maps;

use DefStudio\Actions\Action;
use Illuminate\Support\Facades\DB;
use DefStudio\GameEngine\Models\Map;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Events\Maps\MapDeleted;
use DefStudio\GameEngine\Events\Maps\DeletingMap;

/**
 * @method static void run(Map $map)
 */
class DeleteMap extends Action
{
    public function handle(Map $map): void
    {
        Gate::authorize('delete', $map);

        DB::transaction(function() use ($map): void {
            DeletingMap::dispatch($map);

            $map->delete();

            MapDeleted::dispatch($map);
        });

    }
}
