<?php

namespace DefStudio\GameEngine\Actions\Maps;

use DefStudio\Actions\Action;
use Illuminate\Support\Collection;
use DefStudio\GameEngine\Models\Map;
use DefStudio\GameEngine\DTO\Missions\Placeholder;

/**
 * @method static Collection run(Map $map)
 */
class GetMissionPlaceholders extends Action
{
    public function handle(Map $map): Collection
    {
        return $map->missions
            ->keyBy('id')
            ->mapInto(Placeholder::class);
    }
}
